/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.preferences.OverlayPreferenceStore;
import org.asnlab.asndt.internal.ui.text.folding.FoldingMessages;
import org.asnlab.asndt.ui.text.folding.IAsnFoldingPreferenceBlock;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DefaultAsnFoldingPreferenceBlock
implements IAsnFoldingPreferenceBlock {
    private IPreferenceStore fStore;
    private OverlayPreferenceStore fOverlayStore;
    private OverlayPreferenceStore.OverlayKey[] fKeys;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            DefaultAsnFoldingPreferenceBlock.this.fOverlayStore.setValue((String)DefaultAsnFoldingPreferenceBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };

    public DefaultAsnFoldingPreferenceBlock() {
        this.fStore = AsnPlugin.getDefault().getPreferenceStore();
        this.fKeys = this.createKeys();
        this.fOverlayStore = new OverlayPreferenceStore(this.fStore, this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_comments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_imports"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_exports"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_members"));
        return overlayKeys.toArray(new OverlayPreferenceStore.OverlayKey[overlayKeys.size()]);
    }

    public Control createControl(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        Label label = new Label(inner, 16384);
        label.setText(FoldingMessages.DefaultAsnFoldingPreferenceBlock_title);
        this.addCheckBox(inner, FoldingMessages.DefaultAsnFoldingPreferenceBlock_comments, "editor_folding_default_comments", 0);
        this.addCheckBox(inner, FoldingMessages.DefaultAsnFoldingPreferenceBlock_exports, "editor_folding_default_exports", 0);
        this.addCheckBox(inner, FoldingMessages.DefaultAsnFoldingPreferenceBlock_imports, "editor_folding_default_imports", 0);
        this.addCheckBox(inner, FoldingMessages.DefaultAsnFoldingPreferenceBlock_members, "editor_folding_default_members", 0);
        return inner;
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 1;
        gd.grabExcessVerticalSpace = false;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private void initializeFields() {
        for (Button b : this.fCheckBoxes.keySet()) {
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
    }

    public void performOk() {
        this.fOverlayStore.propagate();
    }

    public void initialize() {
        this.initializeFields();
    }

    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
    }

    public void dispose() {
        this.fOverlayStore.stop();
    }
}

