/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor.selectionactions;

import java.util.List;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.ASTVisitor;
import org.asnlab.asndt.core.dom.CompilationUnitDeclaration;
import org.asnlab.asndt.core.dom.StructuralPropertyDescriptor;
import org.asnlab.asndt.internal.corext.SourceRange;
import org.asnlab.asndt.internal.corext.dom.Selection;
import org.asnlab.asndt.internal.corext.dom.SelectionAnalyzer;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.ASTProvider;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.EditorUtility;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.SelectionActionMessages;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.SelectionHistory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public abstract class StructureSelectionAction
extends Action {
    public static final String NEXT = "SelectNextElement";
    public static final String PREVIOUS = "SelectPreviousElement";
    public static final String ENCLOSING = "SelectEnclosingElement";
    public static final String HISTORY = "RestoreLastSelection";
    private AsnEditor fEditor;
    private SelectionHistory fSelectionHistory;

    protected StructureSelectionAction(String text, AsnEditor editor, SelectionHistory history) {
        super(text);
        Assert.isNotNull((Object)editor);
        Assert.isNotNull((Object)history);
        this.fEditor = editor;
        this.fSelectionHistory = history;
    }

    protected StructureSelectionAction() {
        super("");
    }

    public final void run() {
        IAsnElement inputElement = EditorUtility.getEditorInputAsnElement((IEditorPart)this.fEditor, false);
        if (!(inputElement instanceof ISourceReference) || !inputElement.exists()) {
            return;
        }
        ISourceReference source = (ISourceReference)inputElement;
        try {
            ISourceRange sourceRange = source.getSourceRange();
            if (sourceRange == null || sourceRange.getLength() == 0) {
                MessageDialog.openInformation((Shell)this.fEditor.getEditorSite().getShell(), (String)SelectionActionMessages.StructureSelect_error_title, (String)SelectionActionMessages.StructureSelect_error_message);
                return;
            }
        }
        catch (AsnModelException asnModelException) {}
        ITextSelection selection = this.getTextSelection();
        ISourceRange newRange = this.getNewSelectionRange(StructureSelectionAction.createSourceRange(selection), source);
        if (selection.getOffset() == newRange.getOffset() && selection.getLength() == newRange.getLength()) {
            return;
        }
        this.fSelectionHistory.remember(new SourceRange(selection.getOffset(), selection.getLength()));
        try {
            this.fSelectionHistory.ignoreSelectionChanges();
            this.fEditor.selectAndReveal(newRange.getOffset(), newRange.getLength());
        }
        finally {
            this.fSelectionHistory.listenToSelectionChanges();
        }
    }

    public final ISourceRange getNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr) {
        try {
            CompilationUnitDeclaration root = StructureSelectionAction.getAST(sr);
            if (root == null) {
                return oldSourceRange;
            }
            Selection selection = Selection.createFromStartLength(oldSourceRange.getOffset(), oldSourceRange.getLength());
            SelectionAnalyzer selAnalyzer = new SelectionAnalyzer(selection, true);
            root.accept((ASTVisitor)selAnalyzer);
            return this.internalGetNewSelectionRange(oldSourceRange, sr, selAnalyzer);
        }
        catch (AsnModelException e) {
            AsnPlugin.log(e);
            return new SourceRange(oldSourceRange.getOffset(), oldSourceRange.getLength());
        }
    }

    abstract ISourceRange internalGetNewSelectionRange(ISourceRange var1, ISourceReference var2, SelectionAnalyzer var3) throws AsnModelException;

    protected final ITextSelection getTextSelection() {
        return (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
    }

    protected static ISourceRange getLastCoveringNodeRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws AsnModelException {
        if (selAnalyzer.getLastCoveringNode() == null) {
            return oldSourceRange;
        }
        return StructureSelectionAction.getSelectedNodeSourceRange(sr, selAnalyzer.getLastCoveringNode());
    }

    protected static ISourceRange getSelectedNodeSourceRange(ISourceReference sr, ASTNode nodeToSelect) throws AsnModelException {
        int offset = nodeToSelect.getSourceStart();
        int end = Math.min(sr.getSourceRange().getLength(), nodeToSelect.getSourceEnd());
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ISourceRange createSourceRange(ITextSelection ts) {
        return new SourceRange(ts.getOffset(), ts.getLength());
    }

    private static CompilationUnitDeclaration getAST(ISourceReference sr) {
        return ASTProvider.getASTProvider().getAST((IAsnElement)sr, ASTProvider.WAIT_YES, null);
    }

    static ISourceRange createSourceRange(int offset, int end) {
        int length = end - offset + 1;
        if (length == 0) {
            length = 1;
        }
        return new SourceRange(Math.max(0, offset), length);
    }

    static ASTNode[] getSiblingNodes(ASTNode node) {
        ASTNode parent = node.getParent();
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent.isChildListProperty()) {
            List siblings = (List)parent.getStructuralProperty(locationInParent);
            return siblings.toArray(new ASTNode[siblings.size()]);
        }
        return null;
    }

    static int findIndex(Object[] array, Object o) {
        int i = 0;
        while (i < array.length) {
            Object object = array[i];
            if (object == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

