/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import java.util.Iterator;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.ui.asneditor.IAsnAnnotation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class AsnMarkerAnnotation
extends MarkerAnnotation
implements IAsnAnnotation {
    public static final String ASN_MARKER_TYPE_PREFIX = "org.asnlab.asndt";
    public static final String ERROR_ANNOTATION_TYPE = "org.asnlab.asndt.ui.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.asnlab.asndt.ui.warning";
    public static final String INFO_ANNOTATION_TYPE = "org.asnlab.asndt.ui.info";
    public static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    private IAsnAnnotation fOverlay;

    public AsnMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    public String[] getArguments() {
        IMarker marker = this.getMarker();
        if (marker != null && marker.exists() && this.isProblem()) {
            return null;
        }
        return null;
    }

    public int getId() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return -1;
        }
        if (this.isProblem()) {
            return marker.getAttribute("id", -1);
        }
        return -1;
    }

    public boolean isProblem() {
        String type = this.getType();
        return WARNING_ANNOTATION_TYPE.equals(type) || ERROR_ANNOTATION_TYPE.equals(type);
    }

    public void setOverlay(IAsnAnnotation asnAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = asnAnnotation;
        if (!this.isMarkedDeleted()) {
            this.markDeleted(this.fOverlay != null);
        }
        if (this.fOverlay != null) {
            this.fOverlay.addOverlaid(this);
        }
    }

    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    public IAsnAnnotation getOverlay() {
        return this.fOverlay;
    }

    public void addOverlaid(IAsnAnnotation annotation) {
    }

    public void removeOverlaid(IAsnAnnotation annotation) {
    }

    public Iterator getOverlaidIterator() {
        return null;
    }

    public ICompilationUnit getCompilationUnit() {
        IAsnElement element = AsnCore.create((IResource)this.getMarker().getResource());
        if (element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    public String getMarkerType() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return null;
        }
        return MarkerUtilities.getMarkerType((IMarker)this.getMarker());
    }
}

